module net.BurtonRadons.dig.platform.font;

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.platform.control;

//private import std.c.windows.windows;
private import net.BurtonRadons.dig.common.dispatcher;

//private import std.utf;

/** An OS-specific font object with some public parameters.
  */

class Font
{
    /** Duplicate the parameters of this font. */
    this (Font font)
    {
        this (font.digPlatformLog);
    }
    
    /** Get the dimensions of a line of text in pixels. */
    void textExtent (Control control, char [] text, out int width, out int height)
    {
        _HFONT hfont = digPlatformGetHFONT ();
        _HDC hdc = control.digPlatformHDC;
        wchar [] wtext = std.utf.toUTF16 (text);
        uint result;

        SelectObject (hdc, hfont);
        result = GetTabbedTextExtentW (hdc, wtext, wtext.length, 0, null);
        width = result & 0xFFFF;
        height = result >> 16;
        SelectObject (hdc, control.digPlatformFontSet);
        DeleteObject (hfont);
    }

    /** Get the font height in pixels. */
    int height (Control con)
    {
        return digPlatformGetTextMetric (con).tmHeight;
    }

    /** Set the font height in pixels. */
    void height (int value)
    {
        LOGFONT old = digPlatformLog;
        
        digPlatformLog.lfHeight = value;
        if (old != digPlatformLog)
            digPlatformOnChange.notify ();
    }
    
    /** Return whether this font is bold. */
    bit bold ()
    {
        return digPlatformLog.lfWeight > 550;
    }
    
    /** Set whether this font is bold. */
    void bold (bit value)
    {
        LOGFONT old = digPlatformLog;
        
        digPlatformLog.lfWeight = value ? 700 : 0;
        if (old != digPlatformLog)
            digPlatformOnChange.notify ();
    }
    
    /** Return whether this font is underlined. */
    bit underline ()
    {
        return (bit) digPlatformLog.lfUnderline;
    }

    /** Set whether this font is underlined. */
    void underline (bit value)
    {
        int old = digPlatformLog.lfUnderline;
        
        digPlatformLog.lfUnderline = value;
        if (old != digPlatformLog.lfUnderline)
            digPlatformOnChange.notify ();
    }
    
    /** Return whether this font is struck out. */
    bit strikeout ()
    {
        return (bit) digPlatformLog.lfStrikeOut;
    }

    /** Set whether this font is struck out. */
    void strikeout (bit value)
    {
        int old = digPlatformLog.lfStrikeOut;
        
        digPlatformLog.lfStrikeOut = value;
        if (old != digPlatformLog.lfStrikeOut)
            digPlatformOnChange.notify ();
    }

// OS Specific:
/+
#ifndef DOXYGEN_SHOULD_SKIP_THIS
+/

    LOGFONT digPlatformLog;
    Dispatcher digPlatformOnChange; /**< Notified when any of the font parameters are changed. */

    this (LOGFONT log)
    {
        digPlatformLog = log;
    }

    this (std.c.windows.windows.HGDIOBJ font)
    {
        GetObjectA (font, digPlatformLog.size, &digPlatformLog);
    }
    
    /* Get the TEXTMETRIC structure for this font. */
    TEXTMETRIC digPlatformGetTextMetric (Control control)
    {
        std.c.windows.windows.HFONT hfont = digPlatformGetHFONT ();
        TEXTMETRIC metric;

        SelectObject (control.digPlatformHDC, hfont);
        GetTextMetricsA (control.digPlatformHDC, &metric);
        DeleteObject (hfont);

        return metric;
    }

    _HFONT digPlatformGetHFONT ()
    {
        _HFONT hfont;

        digPlatformLog.lfQuality = std.c.windows.windows.ANTIALIASED_QUALITY;
        hfont = (_HANDLE) CreateFontIndirectA (&digPlatformLog);
        if (hfont == (_HANDLE) 0)
            digPlatformGetLastError ("Font.Font (log)");
        return hfont;
    }

/+
#endif
+/
}

